<?php
include '../db.php';

// Hapus ucapan
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $pdo->prepare("DELETE FROM ucapan WHERE id=?")->execute([$id]);
    header("Location: ucapan.php");
    exit;
}

$stmt = $pdo->query("SELECT u.id, u.ucapan, u.tanggal, t.nama 
                     FROM ucapan u 
                     JOIN tamu t ON u.tamu_id = t.id 
                     ORDER BY u.tanggal DESC");
$ucapanList = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Lihat Ucapan</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <!-- DataTables Bootstrap 5 -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
</head>

<body class="bg-light">

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="index.php">📋 Buku Tamu</a>
        </div>
    </nav>

    <div class="container py-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="fw-bold">Ucapan Tamu</h2>
            <div class="d-flex gap-2">
                <a href="index.php" class="btn btn-outline-primary btn-sm">
                    <i class="bi bi-arrow-left-circle"></i> Kembali
                </a>
                <button class="btn btn-outline-secondary btn-sm" onclick="printTable()">
                    <i class="bi bi-printer"></i> Print Tabel
                </button>
            </div>
        </div>

        <!-- Daftar Ucapan -->
        <div class="card shadow-sm">
            <div class="card-header bg-info text-white">
                <i class="bi bi-chat-dots"></i> Daftar Ucapan
            </div>
            <div class="card-body table-responsive">
                <table class="table table-striped align-middle" id="ucapanTable">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Nama Tamu</th>
                            <th>Ucapan</th>
                            <th>Tanggal</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($ucapanList as $u): ?>
                        <tr>
                            <td><?= $u['id'] ?></td>
                            <td><?= htmlspecialchars($u['nama']) ?></td>
                            <td><?= htmlspecialchars($u['ucapan']) ?></td>
                            <td><?= $u['tanggal'] ?></td>
                            <td class="text-center">
                                <a href="ucapan.php?delete=<?= $u['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Hapus ucapan ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
    // aktifkan DataTable
    $(document).ready(function() {
        $('#ucapanTable').DataTable({
            "pageLength": 10,
            "lengthMenu": [5, 10, 25, 50, 100],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.8/i18n/id.json"
            }
        });
    });

    // print tabel
    function printTable() {
        var table = document.getElementById("ucapanTable").cloneNode(true);
        // hapus kolom aksi
        table.querySelectorAll("tr th:last-child").forEach(th => th.remove());
        table.querySelectorAll("tr").forEach((row, i) => {
            let cells = row.querySelectorAll("td");
            if (cells.length > 0) cells[cells.length - 1].remove();
        });

        var tableHTML = table.outerHTML;
        var win = window.open("", "_blank", "width=900,height=700");
        win.document.open();
        win.document.write(`
                <html>
                <head>
                    <title>Print Tabel</title>
                    <style>
                        body { font-family: Arial, sans-serif; margin:20px; }
                        h2 { text-align:center; margin-bottom:20px; }
                        table { border-collapse: collapse; width: 100%; font-size: 12px; }
                        th, td { border: 1px solid #ccc; padding: 6px; text-align: left; }
                        th { background: #f2f2f2; }
                        td { vertical-align: top; }
                    </style>
                </head>
                <body>
                    <h2>Daftar Ucapan Tamu</h2>
                    ${tableHTML}
                </body>
                </html>
            `);
        win.document.close();
        win.onload = function() {
            win.focus();
            win.print();
            win.close();
        };
    }
    </script>

</body>

</html>