<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'db.php'; 

// Ambil slug dari URL
$slug = $_GET['slug'] ?? '';

// Cari tamu berdasarkan slug
$stmt = $pdo->prepare("SELECT * FROM tamu WHERE slug=?");
$stmt->execute([$slug]);
$tamu = $stmt->fetch();

if (!$tamu) {
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Undangan Tidak Valid</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playwrite+IT+Moderna:wght@400;600&display=swap" rel="stylesheet">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <style>
    body,
    html {
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        background: url("bg.webp") center/cover no-repeat;
        font-family: "Playwrite IT Moderna", serif;
        text-align: center;
    }

    .overlay {
        position: absolute;
        inset: 0;
        background: rgba(0, 0, 0, 0.5);
    }

    .error-box {
        position: relative;
        z-index: 1;
        max-width: 500px;
        padding: 2rem;
        background: rgba(255, 255, 255, 0.85);
        border: 2px solid #d4af37;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
    }

    .error-box h1 {
        color: #d4af37;
        font-size: 2rem;
        margin: 0 0 10px 0;
        letter-spacing: 2px;
    }

    .error-box p {
        color: #333;
        font-size: 1rem;
        margin: 0;
    }
    </style>
</head>

<body>
    <div class="overlay"></div>
    <div class="error-box">
        <h1><i class="bx bx-sad"></i> Link Undangan Tidak Ditemukan</h1>
        <p>Maaf, tautan undangan yang Anda buka tidak ditemukan atau sudah tidak aktif.</p>
    </div>
</body>

</html>
<?php
    exit;
}

// Ambil daftar ucapan tamu
$stmt2 = $pdo->prepare("SELECT * FROM ucapan WHERE tamu_id=? ORDER BY tanggal DESC");
$stmt2->execute([$tamu['id']]);
$ucapanList = $stmt2->fetchAll();
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Undangan Pernikahan</title>
    <link rel="stylesheet" href="assets/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Playwrite+IT+Moderna:wght@300;400;600;700&display=swap" rel="stylesheet">

    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>
    <script>
    new WOW().init();
    </script>
</head>

<body>
    <!-- Cover Undangan -->
    <div class="cover" id="cover">
        <div class="cover-content">
            <div class="cover-top">
                <h2 class="gold wow animate__animated animate__fadeInDown">The Wedding of</h2>
                <h1 class="wow animate__animated animate__zoomIn" data-wow-delay="0.5s">Kinkin & Ricky</h1>
            </div>

            <div class="cover-bottom">
                <p class="wow animate__animated animate__fadeInUp">Kepada :</p>
                <h2 class="wow animate__animated animate__fadeIn" data-wow-delay="0.5s"><span id=" namaTamu"><?= htmlspecialchars($tamu['nama']) ?></span></h2>
                <button class="btn wow animate__animated animate__fadeInLeft" data-wow-delay="0.8s" onclick="bukaUndangan()">Buka Undangan</button>
                <button class="btn wow animate__animated animate__fadeInRight" data-wow-delay="0.8s" onclick="copyLink()">Salin Link</button>
            </div>
        </div>
    </div>

    <!-- Musik Latar -->
    <audio id="bgMusic" loop>
        <source src="assets/au.mp3" type="audio/mpeg">
    </audio>

    <!-- Bagian Pembuka -->
    <div class="bg-fixed"></div>
    <section id="wedding">
        <div class="content wow animate__animated animate__pulse animate__slow" data-wow-iteration="infinite">
            <p class="mb-0">The Wedding Of</p>
            <h1 class="gold">Kinkin Suandari</h1>
            <h2>&</h2>
            <h1 class="gold">Ricky Agustian</h1>
            <p>18 Oktober 2025</p>
        </div>
        <!-- Icon scroll -->
        <div class="scroll-down">
            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="white" viewBox="0 0 24 24">
                <path d="M12 21l-12-18h24z" />
            </svg>
        </div>
    </section>

    <!-- Ayat & Foto Pengantin -->
    <section id="mempelai">
        <div class="mempelai-wrapper">
            <div class="foto-mempelai">
                <img src="assets/mempelai.webp" alt="Foto Mempelai">
            </div>
            <div class="mempelai-box">
                <h2 class="inisial">K & R</h2>
                <p>
                    "Di antara tanda-tanda (kebesaran)-Nya ialah bahwa Dia menciptakan pasangan-pasangan untukmu
                    dari (jenis) dirimu sendiri agar kamu merasa tenteram kepadanya. Dia menjadikan di antaramu
                    rasa cinta dan kasih sayang. Sesungguhnya pada yang demikian itu benar-benar terdapat
                    tanda-tanda (kebesaran Allah) bagi kaum yang berpikir."
                </p>
                <p>~ (QS. Ar-Rum: 21) ~</p>
            </div>
        </div>
    </section>

    <!-- Profil Pengantin -->
    <section id="mempelai2">
        <div class="mempelai2-wrapper">
            <div class="mempelai2-box">
                <h2 class="gold">We are</h2>
                <h2 class="gold">Getting Married</h2>
                <hr>
                <p>Maha suci ALLAH yang telah menciptakan makhluk-Nya berpasang-pasangan. Ya ALLAH semoga ridho-Mu
                    tercurah mengiringi pernikahan kami:</p>
                <hr><br>

                <div class="mempelai2-foto">
                    <img src="assets/kinkin.webp" alt="Kinkin Suandari">
                </div>
                <h1><b>Kinkin</b></h1>
                <h3>Kinkin Suandari</h3>
                <p>Putri Pertama dari Bapak Suandi & Ibu Siti Aminah</p>

                <h1>&</h1><br>

                <div class="mempelai2-foto">
                    <img src="assets/ricky.webp" alt="Ricky Agustian">
                </div>
                <h1><b>Ricky</b></h1>
                <h3>Ricky Agustian</h3>
                <p>Putra Kedua dari Bapak Beni Rustana & Ibu Ai</p>
            </div>
        </div>
    </section>

    <!-- Transisi Foto -->
    <section id="transisi-foto1"></section>
    <section id="transisi-foto2"></section>

    <!-- Jadwal Acara -->
    <section id="acara">
        <h2 class="gold">Love The Date</h2>

        <!-- Countdown Timer -->
        <div id="countdown">
            <div class="time-box"><span id="days">0</span><small>Days</small></div>
            <div class="time-box"><span id="hours">0</span><small>Hours</small></div>
            <div class="time-box"><span id="minutes">0</span><small>Minutes</small></div>
            <div class="time-box"><span id="seconds">0</span><small>Seconds</small></div>
        </div>

        <p>Dengan Rahmat dan Ridho ALLAH SWT, Kami mengundang Bapak/Ibu/Saudara/i, untuk menghadiri acara
            pernikahan kami:</p>

        <div class="floral1">
            <img src="assets/floral_transparent.png" alt="Floral Decoration">
        </div>

        <div class="acara-card">
            <h2>Akad Nikah</h2>
            <h3 class="it">Sabtu</h3>
            <h3>18 Oktober 2025</h3>
            <p><b>08.00 - Selesai</b></p>
            <br>
            <p><i class="bx bx-map"></i></p>
            <p>GOR Desa Nagreg</p>
            <button onclick="window.open('https://maps.app.goo.gl/M5PF64yuFfp4wYnH8', '_blank')">📍Google Map</button>
        </div>

        <div class="floral2">
            <img src="assets/floral_transparent.png" alt="Floral Decoration">
        </div>

        <div class="acara-card">
            <h2>Resepsi Pernikahan</h2>
            <h3 class="it">Sabtu</h3>
            <h3>18 Oktober 2025</h3>
            <p><b>11.00 - Selesai</b></p>
            <br>
            <p><i class="bx bx-map"></i></p>
            <p>GOR Desa Nagreg</p>
            <button onclick="window.open('https://maps.app.goo.gl/M5PF64yuFfp4wYnH8', '_blank')">📍Google Map</button>
        </div>
    </section>

    <!-- Galeri Foto -->
    <section id="galeri">
        <h2 class="gold">Our Gallery</h2>
        <div class="gallery-grid">
            <div class="gallery-item tall"><img src="assets/galeri1.webp" alt="Foto 1"></div>
            <div class="gallery-item"><img src="assets/galeri2.webp" alt="Foto 2"></div>
            <div class="gallery-item"><img src="assets/transisi-1.webp" alt="Foto 3"></div>
            <div class="gallery-item"><img src="assets/galeri3.webp" alt="Foto 4"></div>
            <div class="gallery-item tall"><img src="assets/galeri4.webp" alt="Foto 5"></div>
            <div class="gallery-item"><img src="assets/galeri5.webp" alt="Foto 6"></div>
        </div>
    </section>

    <!-- Gift Tamu -->
    <section class="gift">
        <h2 class="gold">Wedding Gift</h2>
        <p>Merupakan suatu kehormatan dan kebahagiaan bagi kami, apabila Bapak/Ibu/Saudara/i berkenan hadir
            untuk memberikan doa restu kepada kami. Namun, apabila berkenan memberikan hadiah, Anda dapat
            mengirimkannya melalui rekening di bawah ini:</p>
        <div class="rekening-box">
            <p><b>Bank Central Asia (BCA)</b></p>
            <p><b>123-456-7890</b></p>
            <p>a.n Kinkin Suandari</p>
        </div>
        <p>Atau klik tombol di bawah untuk menyalin nomor rekening:</p>
        <button class="btn" onclick="navigator.clipboard.writeText('123-456-7890').then(() => { alert('Nomor rekening berhasil disalin!'); })">Salin
            Nomor
            Rekening</button>
    </section>

    <!-- Ucapan Tamu -->
    <section id="ucapan">
        <h2 class="gold">Whises</h2>
        <p>Ucapan dan Do'a</p>
        <form id="formUcapan">
            <textarea name="ucapan" placeholder="Tulis ucapan..." required></textarea><br>
            <button type="submit" class="btn">Kirim</button>
        </form>

        <hr>

        <h3>Ucapan Tamu</h3>
        <div id="listUcapan">
            <?php foreach ($ucapanList as $u): ?>
            <p><em><?= htmlspecialchars($u['ucapan']) ?></em><br>
                <small><?= $u['tanggal'] ?></small>
            </p>
            <?php endforeach; ?>
        </div>
    </section>

    <section id="transisi-foto3">
        <p>Suatu kebahagiaan & kehormatan bagi kami, apabila Bapak/Ibu/Saudara/i, berkenan hadir dan memberikan do'a
            restu kepada kami
        </p>
        <br>
        <br>
        <br>
        <br>
        <p><b>Kami yang berbahagia,</b></p>
        <h2 class="gold">Kinkin & Ricky</h2>
    </section>

    <!-- Footer -->
    <footer>
        <p>Supported by Pancar</p>
    </footer>

    <!-- Script -->
    <script src="assets/script.js"></script>
    <script>
    // Copy link undangan
    function copyLink() {
        navigator.clipboard.writeText(window.location.href).then(() => {
            alert("Link undangan berhasil disalin!");
        });
    }

    // Kirim ucapan via AJAX
    // Kirim ucapan via AJAX
    document.getElementById("formUcapan").addEventListener("submit", function(e) {
        e.preventDefault();
        const ucapan = this.ucapan.value;

        fetch("save_ucapan.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: "tamu_id=<?= $tamu['id'] ?>&ucapan=" + encodeURIComponent(ucapan)
            })
            .then(r => r.text())
            .then(res => {
                if (res === "success") {
                    this.reset(); // kosongkan form
                    loadUcapan(); // refresh daftar ucapan tanpa reload halaman
                } else {
                    alert("Gagal mengirim ucapan");
                }
            });
    });

    // Fungsi load ucapan pakai AJAX
    function loadUcapan() {
        fetch("get_ucapan.php?tamu_id=<?= $tamu['id'] ?>")
            .then(r => r.text())
            .then(html => {
                document.getElementById("listUcapan").innerHTML = html;
            });
    }

    // Refresh otomatis tiap 5 detik
    setInterval(loadUcapan, 5000);

    // Jalankan pertama kali
    document.addEventListener("DOMContentLoaded", () => {
        loadUcapan();
        setTimeout(() => {
            autoScrollUcapan();
        }, 3000);
    });

    // Auto scroll ucapan looping
    function autoScrollUcapan() {
        const box = document.getElementById("listUcapan");
        let scrollStep = 1; // kecepatan scroll
        let interval = setInterval(() => {
            if (box.scrollTop + box.clientHeight >= box.scrollHeight) {
                // kalau sudah sampai bawah, balik ke atas
                box.scrollTop = 0;
            } else {
                box.scrollTop += scrollStep;
            }
        }, 100); // tiap 100ms scroll 1px
    }

    // Jalankan setelah halaman siap
    document.addEventListener("DOMContentLoaded", () => {
        setTimeout(() => {
            autoScrollUcapan();
        }, 3000);
    });

    // Animasi fade-in mempelai
    document.addEventListener("DOMContentLoaded", () => {
        const observer = new IntersectionObserver((entries, obs) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add("show");
                    obs.unobserve(entry.target);
                }
            });
        }, {
            threshold: 0.3
        });

        document.querySelectorAll(".foto-mempelai, .mempelai-box, .mempelai2-box, .mempelai2-foto")
            .forEach(el => observer.observe(el));
    });

    // Countdown Timer
    document.addEventListener("DOMContentLoaded", function() {
        const akadDate = new Date("October 18, 2025 08:00:00").getTime();
        const daysEl = document.getElementById("days");
        const hoursEl = document.getElementById("hours");
        const minutesEl = document.getElementById("minutes");
        const secondsEl = document.getElementById("seconds");

        function updateCountdown() {
            const now = new Date().getTime();
            const distance = akadDate - now;

            if (distance <= 0) {
                document.getElementById("countdown").innerHTML = "<h3>Acara sedang berlangsung 🎉</h3>";
                clearInterval(timer);
                return;
            }

            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            daysEl.textContent = days;
            hoursEl.textContent = hours;
            minutesEl.textContent = minutes;
            secondsEl.textContent = seconds;
        }

        const timer = setInterval(updateCountdown, 1000);
        updateCountdown();
    });
    </script>
</body>

</html>